/* strcspn (str, ss) -- Return the length of the initial segement of STR
			which contains no characters from SS.
   For Intel 80x86, x>=3.
   Copyright (C) 1994, 1995, 1996, 1997, 2000 Free Software Foundation, Inc.
   Contributed by Ulrich Drepper <drepper@gnu.ai.mit.edu>
   Bug fixes by Alan Modra <Alan@SPRI.Levels.UniSA.Edu.Au>
   This file is part of the GNU C Library.

   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the GNU C Library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307 USA.  */

#include <sysdep.h>
#include "asm-syntax.h"
#include "bp-sym.h"
#include "bp-asm.h"

#define PARMS	LINKAGE		/* no space for saved regs */
#define RTN	PARMS
#define STR	RTN+RTN_SIZE
#define STOP	STR+PTR_SIZE

	.text
ENTRY (BP_SYM (strpbrk))
	ENTER

	movl STR(%esp), %edx
	movl STOP(%esp), %eax
	CHECK_BOUNDS_LOW (%edx, STR(%esp))

	/* First we create a table with flags for all possible characters.
	   For the ASCII (7bit/8bit) or ISO-8859-X character sets which are
	   supported by the C string functions we have 256 characters.
	   Before inserting marks for the stop characters we clear the whole
	   table.  The unrolled form is much faster than a loop.  */
	xorl %ecx, %ecx		/* %ecx = 0 !!! */

	pushl %ecx		/* make a 256 bytes long block filled with 0 */
	pushl %ecx
	pushl %ecx
	pushl %ecx
	pushl %ecx
	pushl %ecx
	pushl %ecx
	pushl %ecx
	pushl %ecx
	pushl %ecx
	pushl %ecx
	pushl %ecx
	pushl %ecx
	pushl %ecx
	pushl %ecx
	pushl %ecx
	pushl %ecx
	pushl %ecx
	pushl %ecx
	pushl %ecx
	pushl %ecx
	pushl %ecx
	pushl %ecx
	pushl %ecx
	pushl %ecx
	pushl %ecx
	pushl %ecx
	pushl %ecx
	pushl %ecx
	pushl %ecx
	pushl %ecx
	pushl %ecx
	pushl %ecx
	pushl %ecx
	pushl %ecx
	pushl %ecx
	pushl %ecx
	pushl %ecx
	pushl %ecx
	pushl %ecx
	pushl %ecx
	pushl %ecx
	pushl %ecx
	pushl %ecx
	pushl %ecx
	pushl %ecx
	pushl %ecx
	pushl %ecx
	pushl %ecx
	pushl %ecx
	pushl %ecx
	pushl %ecx
	pushl %ecx
	pushl %ecx
	pushl %ecx
	pushl %ecx
	pushl %ecx
	pushl %ecx
	pushl $0		/* These immediate values make the label 2 */
	pushl $0		/* to be aligned on a 16 byte boundary to */
	pushl $0		/* get a better performance of the loop.  */
	pushl $0
	pushl $0
	pushl $0

/* For understanding the following code remember that %ecx == 0 now.
   Although all the following instruction only modify %cl we always
   have a correct zero-extended 32-bit value in %ecx.  */

/* Don't change the "testb $0xff,%%cl" to "testb %%cl,%%cl".  We want
   longer instructions so that the next loop aligns without adding nops.  */

L(2):	movb (%eax), %cl	/* get byte from stopset */
	testb %cl, %cl		/* is NUL char? */
	jz L(1)			/* yes => start compare loop */
	movb %cl, (%esp,%ecx)	/* set corresponding byte in stopset table */

	movb 1(%eax), %cl	/* get byte from stopset */
	testb $0xff, %cl	/* is NUL char? */
	jz L(1)			/* yes => start compare loop */
	movb %cl, (%esp,%ecx)	/* set corresponding byte in stopset table */

	movb 2(%eax), %cl	/* get byte from stopset */
	testb $0xff, %cl	/* is NUL char? */
	jz L(1)			/* yes => start compare loop */
	movb %cl, (%esp,%ecx)	/* set corresponding byte in stopset table */

	movb 3(%eax), %cl	/* get byte from stopset */
	addl $4, %eax		/* increment stopset pointer */
	movb %cl, (%esp,%ecx)	/* set corresponding byte in stopset table */
	testb $0xff, %cl	/* is NUL char? */
	jnz L(2)		/* no => process next dword from stopset */

L(1):	leal -4(%edx), %eax	/* prepare loop */

	/* We use a neat trick for the following loop.  Normally we would
	   have to test for two termination conditions
	   1. a character in the stopset was found
	   and
	   2. the end of the string was found
	   But as a sign that the chracter is in the stopset we store its
	   value in the table.  But the value of NUL is NUL so the loop
	   terminates for NUL in every case.  */

L(3):	addl $4, %eax		/* adjust pointer for full loop round */

	movb (%eax), %cl	/* get byte from string */
	cmpb %cl, (%esp,%ecx)	/* is it contained in stopset? */
	je L(4)			/* yes => return */

	movb 1(%eax), %cl	/* get byte from string */
	cmpb %cl, (%esp,%ecx)	/* is it contained in stopset? */
	je L(5)			/* yes => return */

	movb 2(%eax), %cl	/* get byte from string */
	cmpb %cl, (%esp,%ecx)	/* is it contained in stopset? */
	je L(6)			/* yes => return */

	movb 3(%eax), %cl	/* get byte from string */
	cmpb %cl, (%esp,%ecx)	/* is it contained in stopset? */
	jne L(3)			/* yes => return */

	incl %eax		/* adjust pointer */
L(6):	incl %eax
L(5):	incl %eax

L(4):	addl $256, %esp		/* remove stopset */

	CHECK_BOUNDS_HIGH (%eax, STR(%esp), jb)
	orb %cl, %cl		/* was last character NUL? */
	jnz L(7)		/* no => return pointer */
	xorl %eax, %eax
	RETURN_NULL_BOUNDED_POINTER

	LEAVE
	RET_PTR

L(7):	RETURN_BOUNDED_POINTER (STR(%esp))

	LEAVE
	RET_PTR
END (BP_SYM (strpbrk))
