# GNU Solfege - eartraining for GNOME
# Copyright (C) 2000-2001  Tom Cato Amundsen
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


import string
import gnome.config
import configureoutput

_watches = {}
_watch_counter = 0

app_id = 'solfege%s.%s' % (configureoutput.MAJOR_VERSION,
                           configureoutput.MINOR_VERSION)
class ConfigUtils:
    def __init__(self, exname):
        self.m_exname = exname
    def add_watch(self, name, callback):
        global _watches, _watch_counter
        name = self._expand_name(name)
        if not _watches.has_key(name):
            _watches[name] = {}
        _watches[name][_watch_counter] = callback
        _watch_counter = _watch_counter + 1
        return _watch_counter - 1
    def remove_watch(self, name, id):
        global _watches, _watch_counter
        name = self._expand_name(name)
        if _watches.has_key(name):
            if _watches[name].has_key(id):
                del _watches[name][id]
                if _watches[name] == {}:
                    del _watches[name]
            else:
                print "warning: remove_watch: id don't exist:", id
        else:
            print "warning: remove_watch: name is not watched:", name
    def _expand_name(self, name):
        if string.count(name, "/") == 0:
            return "%s/%s/%s" % (app_id, self.m_exname, name)
        elif string.count(name, "/") == 1:
            return "%s/%s" % (app_id, name)
        elif string.count(name, "/") > 1:
            a, b, c = string.split(name, "/")
            if a != app_id:
                print "cfg: _expand_name: illegal name:", name
        return name
    def _set(self, func, name, val):
        global _watches
        name = self._expand_name(name)
        oldval = gnome.config.get_string(name)
        func(name, val)
        newval = gnome.config.get_string(name)
        if _watches.has_key(name) and (oldval != newval):
            for cb in _watches[name].values():
               cb(name)
    def set_int(self, name, val):
        self._set(gnome.config.set_int, name, val)
    def set_float(self, name, val):
        self._set(gnome.config.set_float, name, val)
    def set_string(self, name, val):
        self._set(gnome.config.set_string, name, val)
    def set_list(self, name, val):
        self._set(gnome.config.set_string, name, str(val))
    def set_bool(self, name, val):
        self._set(gnome.config.set_bool, name, val)
    def _get(self, func, name, default=""):
        return func(self._expand_name(name)+default)
    def get_int(self, name):
        return self._get(gnome.config.get_int, name)
    def get_int_with_default(self, name, default):
        assert type(default) is type(0)
        return self.get_int(name+"=%i" % default)
    def get_float(self, name):
        return self._get(gnome.config.get_float, name)
    def get_string(self, name):
        r = self._get(gnome.config.get_string, name)
        if r is None:
            return ""
        else:
            return r
    def get_list(self, name):
        return eval(self._get(gnome.config.get_string, name, "=[]"))
    def get_bool(self, name):
        return self._get(gnome.config.get_bool, name)
    def get_vector(self, name):
        return self._get(gnome.config.get_vector, name)

# these functions are needed because sometimes it is necessary
# to set/get data without doing it in a class derived from ConfigUtils
_c = ConfigUtils("")
get_string = _c.get_string
get_int = _c.get_int
get_bool = _c.get_bool
get_vector = _c.get_vector
set_string = _c.set_string
set_int = _c.set_int
set_bool = _c.set_bool

def clean_file():
    gnome.config.clean_file(app_id)
def clean_section(section):
    gnome.config.clean_section(app_id + "/" + section)
def clean_key(key):
    gnome.config.clean_key(app_id + "/" + key)
def sync():
    gnome.config.sync()

